IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Balance_Sumas_Saldos_Rpt') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Balance_Sumas_Saldos_Rpt
END
GO

CREATE PROCEDURE [dbo].[CPJ_Balance_Sumas_Saldos_Rpt]	@pJson VARCHAR(8000)
AS
SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug			    		TINYINT
DECLARE @pId_Usuario					SMALLINT
DECLARE @pFecha_Desde					DATETIME
DECLARE @pFecha_Hasta					DATETIME
DECLARE @pFlag_incluirSoloAsientos		TINYINT
DECLARE @pFlag_FiltrarId_CC				TINYINT
DECLARE @pId_Centro_Costo				CHAR(10)
DECLARE @pId_Plan_Cta					INT
DECLARE @pId_Unid_Negocio				CHAR(10)
DECLARE @pFlag_Desglozar_CC	    		TINYINT
DECLARE @pFlag_Excluir_Asientos_Cierre	TINYINT
DECLARE @pId_Alias_Cta_Contable			INT

SET @pModoDebug						= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario					= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pFecha_Desde					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), '19000101')
SET @pFecha_Hasta					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), '19000101')
SET @pFlag_incluirSoloAsientos		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_incluirSoloAsientos')), 0)
SET @pFlag_FiltrarId_CC				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_FiltrarId_CC')), 0)
SET @pId_Centro_Costo				= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Centro_Costo')), '')
SET @pId_Plan_Cta					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Plan_Cta')), 0)
SET @pId_Unid_Negocio				= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Unid_Negocio')), '')
SET @pFlag_Desglozar_CC				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Desglozar_CC')), 0)
SET @pFlag_Excluir_Asientos_Cierre	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Excluir_Asientos_Cierre')), 0)
SET @pId_Alias_Cta_Contable			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Alias_Cta_Contable')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @SqlStr						NVARCHAR(MAX)
DECLARE @TipoAsientoCierre			VARCHAR(8000)
DECLARE @Id_Cta_Contable			INT
DECLARE @Debe_Suma					DECIMAL(20,2)
DECLARE @Haber_Suma					DECIMAL(20,2)
DECLARE @Nro_Cta_Contable			VARCHAR(20)
DECLARE @Alias						DECIMAL(12,0)
DECLARE @Cta_Contable				VARCHAR(80)
DECLARE @Id_Centro_Costo			VARCHAR(10)
DECLARE @Centro_Costo				VARCHAR(200)
DECLARE @Anterior					DECIMAL(20,2)
DECLARE @Debe						DECIMAL(20,2)
DECLARE @Haber						DECIMAL(20,2)
DECLARE @Diferencia					DECIMAL(20,2)
DECLARE @Deudor						DECIMAL(20,2)
DECLARE @Acreedor					DECIMAL(20,2)
DECLARE @Columna_Bal				INT
DECLARE @Alias_Cta_Padre			DECIMAL(12,0)
DECLARE @PCE_Fecha_Inicio			DATETIME
DECLARE @PCE_Fecha_Cierre			DATETIME
DECLARE @Id_Ejercicio				INT
DECLARE @Flag_Existe_Registro_En_Cola TINYINT
/*FIN Variables Locales*/

BEGIN TRY
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Balance_Sumas_Saldos_Rpt'
		PRINT 'Parametros: '
		PRINT '@pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. @pFecha_Desde: ' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + '. @pFecha_Hasta: ' + CONVERT(VARCHAR(10), @pFecha_Hasta, 112) +'. @pFlag_FiltrarId_CC: ' + CONVERT(VARCHAR(10), @pFlag_FiltrarId_CC) + '. @pId_Centro_Costo: ' + CONVERT(VARCHAR(10), @pId_Centro_Costo)
		PRINT '@pFlag_incluirSoloAsientos: ' + CONVERT(VARCHAR(10), @pFlag_incluirSoloAsientos) + '. @pId_Plan_Cta: ' + CONVERT(VARCHAR(10), @pId_Plan_Cta) + '. @pId_Unid_Negocio: ' + @pId_Unid_Negocio + '. @pFlag_Desglozar_CC: ' + CONVERT(VARCHAR(10), @pFlag_Desglozar_CC) + '. @pFlag_Excluir_Asientos_Cierre: ' + CONVERT(VARCHAR(10), @pFlag_Excluir_Asientos_Cierre) 
	END

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pId_Usuario = 0)
	BEGIN
		SET @pId_Usuario = -1
	END
	
	IF(@pFecha_Desde = '19000101')								RAISERROR ('Fecha_Desde can not be blank.', 16,  1)
	IF(@pFecha_Hasta = '19000101')								RAISERROR ('Fecha_Hasta can not be blank.', 16,  1) 
	IF(@pFecha_Desde >= @pFecha_Hasta)							RAISERROR ('Fecha_Desde can not be bigger or equal than Fecha_Hasta.', 16,  1) 
	IF(DATEDIFF(YEAR, @pFecha_Desde, @pFecha_Hasta) > 0)		RAISERROR ('Diference between Fecha_Desde and Fecha_Hasta can not be bigger than a year.', 16,  1) 	
	IF(@pId_Plan_Cta = 0)										RAISERROR ('Id_Plan_Cta can not be zero.', 16,  1) 
	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		IF(@pId_Centro_Costo = '')									RAISERROR ('ID_Centro_Costo can not be blank.', 16,  1)
	END
	
	/*=============================================================================================================================*/

	SET @TipoAsientoCierre = dbo.CF_xParam('Tipo_Asto_Cierre')

	/*=============================================================================================================================*/
	
	CREATE TABLE #Rpt_Balance_Sumas_Saldos
	(
	Nro_Cta_Contable				VARCHAR(20),
	Alias							DECIMAL(12,0),
	Cta_Contable					VARCHAR(80),
	Id_Centro_Costo					VARCHAR(10),
	Centro_Costo					VARCHAR(200),
	Anterior						DECIMAL(20,2),
	Debe							DECIMAL(20,2),
	Haber							DECIMAL(20,2),
	Diferencia						DECIMAL(20,2),
	Deudor							DECIMAL(20,2),
	Acreedor						DECIMAL(20,2),
	Columna_Bal						INT,
	Alias_Cta_Padre					DECIMAL(12,0)
	)

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'ASIENTOS'
	END

	CREATE TABLE #Asientos_Sumas_Saldos
	(
	Id_Cta_Contable					INT,
	Debe_Suma						DECIMAL(20,2),
	Haber_Suma						DECIMAL(20,2)
	)

	/*=============================================================================================================================*/

	SET @SqlStr = 'INSERT INTO #Asientos_Sumas_Saldos (Id_Cta_Contable, Debe_Suma, Haber_Suma) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13) + 
					'SUM(I.Debe), '														+ CHAR(13) + 
					'SUM(I.Haber) '														+ CHAR(13) + 
					'FROM Asientos_Items I, Asientos A '								+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Asiento = I.Id_Asiento '										+ CHAR(13) + 
					'AND A.Balanceado = 1 '												+ CHAR(13) + 
					'AND A.Id_Plan_Cta = '	+ CONVERT(VARCHAR(10), @pId_Plan_Cta)

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '

	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pFlag_Excluir_Asientos_Cierre <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Tipo_Asi NOT IN (' + @TipoAsientoCierre + ') '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Alias_Cta_Cont = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'GROUP BY Id_Cta_Contable'

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr
	
	/*=============================================================================================================================*/

	DECLARE curBalance_Sumas_Saldos_Cur CURSOR FOR
	SELECT 
	Id_Cta_Contable,
	Debe_Suma,
	Haber_Suma
	FROM #Asientos_Sumas_Saldos

	OPEN curBalance_Sumas_Saldos_Cur
	FETCH NEXT FROM curBalance_Sumas_Saldos_Cur INTO @Id_Cta_Contable, @Debe_Suma, @Haber_Suma
	WHILE @@FETCH_STATUS = 0
	BEGIN

		SELECT
		@Nro_Cta_Contable	= ISNULL(Nro_Cta_Contable, ''),
		@Alias				= ISNULL(Alias, 0),
		@Cta_Contable		= ISNULL(Descripcion, ''),
		@Columna_Bal		= ISNULL(Columna, 0),
		@Alias_Cta_Padre	= ISNULL(Id_Cuenta_Padre, 0)
		FROM Pla_Ctas_Cuentas_Contables
		WHERE
		Id_Cta_Contable = @Id_Cta_Contable

		SET @Debe		= @Debe_Suma
		SET @Haber		= @Haber_Suma
		SET @Diferencia	= @Debe - @Haber

		IF(@Diferencia < 0)
		BEGIN
			SET @Acreedor	= @Diferencia * (-1)
		END
		ELSE
		BEGIN
			SET @Deudor		= @Diferencia
		END

		SET @Id_Centro_Costo	= 0
		SET @Centro_Costo		= ''
		SET @Anterior			= 0

		INSERT INTO #Rpt_Balance_Sumas_Saldos
		(Nro_Cta_Contable,
		Alias,
		Cta_Contable,
		Id_Centro_Costo,
		Centro_Costo,
		Anterior,
		Debe,
		Haber,
		Diferencia,
		Deudor,
		Acreedor,
		Columna_Bal,
		Alias_Cta_Padre)
		VALUES
		(@Nro_Cta_Contable,
		@Alias,
		@Cta_Contable,
		@Id_Centro_Costo,
		@Centro_Costo,
		@Anterior,
		@Debe,
		@Haber,
		@Diferencia,
		@Deudor,
		@Acreedor,
		@Columna_Bal,
		@Alias_Cta_Padre)

		FETCH NEXT FROM curBalance_Sumas_Saldos_Cur INTO @Id_Cta_Contable, @Debe_Suma, @Haber_Suma
	END
	CLOSE curBalance_Sumas_Saldos_Cur
	DEALLOCATE curBalance_Sumas_Saldos_Cur

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'COMPROBANTES'
	END

	CREATE TABLE #Cbtes_Sumas_Saldos
	(
	Id_Cta_Contable					INT,
	Debe_Suma						DECIMAL(20,2),
	Haber_Suma						DECIMAL(20,2)
	)

	SELECT
	@Id_Ejercicio	= ISNULL(Id_Ejercicio, 0)
	FROM Plan_Ctas
	WHERE
	Id_Plan_Cta = @pId_Plan_Cta

	SELECT
	@Id_Ejercicio	= ISNULL(Id_Ejercicio, 0)
	FROM Plan_Ctas_Ejercicios
	WHERE
	Id_Ejercicio = @Id_Ejercicio

	SELECT
	@PCE_Fecha_Inicio = ISNULL(Fecha_Inicio, '19000101'),
	@PCE_Fecha_Cierre = ISNULL(Fecha_Cierre, '19000101')
	FROM Plan_Ctas_Ejercicios
	WHERE
	Id_Ejercicio = @Id_Ejercicio

	/*=============================================================================================================================*/

	SET @SqlStr = 'INSERT INTO #Cbtes_Sumas_Saldos (Id_Cta_Contable, Debe_Suma, Haber_Suma) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13) + 
					'SUM(I.Debe), '														+ CHAR(13) + 
					'SUM(I.Haber) '														+ CHAR(13) + 
					'FROM Cbtes_Ctas_Contables I, Cbtes A, Cbtes_Tipos T '				+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Trans = I.Id_Trans '											+ CHAR(13) + 
					'AND ISNULL(I.Id_Asiento, 0) = 0 '									+ CHAR(13) + 
					'AND A.Id_Tipo_Cbte = T.Id_Tipo_Cbte '								+ CHAR(13) + 
					'AND ISNULL(T.Compromete_Asientos, 0) <> 0 '						+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 0'											+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 3'

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva >= ''' + CONVERT(VARCHAR(10), @PCE_Fecha_Inicio, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @PCE_Fecha_Cierre), 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '

	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Alias = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'GROUP BY Id_Cta_Contable'

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr
	
	/*=============================================================================================================================*/

	DECLARE curBalance_Sumas_Saldos_Cur CURSOR FOR
	SELECT 
	Id_Cta_Contable,
	Debe_Suma,
	Haber_Suma
	FROM #Cbtes_Sumas_Saldos

	OPEN curBalance_Sumas_Saldos_Cur
	FETCH NEXT FROM curBalance_Sumas_Saldos_Cur INTO @Id_Cta_Contable, @Debe_Suma, @Haber_Suma
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @Nro_Cta_Contable	= ''
		SET @Alias				= 0
		SET @Cta_Contable		= ''
		SET @Id_Centro_Costo	= ''
		SET @Centro_Costo		= ''
		SET @Anterior			= 0
		SET @Debe				= 0
		SET @Haber				= 0
		SET @Diferencia			= 0
		SET @Deudor				= 0
		SET @Acreedor			= 0
		SET @Columna_Bal		= 0
		SET @Alias_Cta_Padre	= 0

		SELECT
		@Nro_Cta_Contable	= ISNULL(Nro_Cta_Contable, ''),
		@Alias				= ISNULL(Alias, 0),
		@Cta_Contable		= ISNULL(Descripcion, ''),
		@Columna_Bal		= ISNULL(Columna, 0),
		@Alias_Cta_Padre	= ISNULL(Id_Cuenta_Padre, 0)
		FROM Pla_Ctas_Cuentas_Contables
		WHERE
		Id_Cta_Contable = @Id_Cta_Contable

		SET @Id_Centro_Costo	= 0
		SET @Centro_Costo		= ''
		SET @Anterior			= 0

		SET @Flag_Existe_Registro_En_Cola = ISNULL((SELECT MAX(1) 
													FROM #Rpt_Balance_Sumas_Saldos 
													WHERE 
													Nro_Cta_Contable = @Nro_Cta_Contable)
													, 0)
		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Flag_Existe_Registro_En_Cola: ' + CONVERT(VARCHAR(10), @Flag_Existe_Registro_En_Cola)
		END

		IF(@Flag_Existe_Registro_En_Cola = 0)
		BEGIN
			SET @Debe		= @Debe_Suma
			SET @Haber		= @Haber_Suma
			SET @Diferencia	= @Debe - @Haber

			IF(@Diferencia < 0)
			BEGIN
				SET @Acreedor	= @Diferencia * (-1)
			END
			ELSE
			BEGIN
				SET @Deudor		= @Diferencia
			END

			INSERT INTO #Rpt_Balance_Sumas_Saldos
			(Nro_Cta_Contable,
			Alias,
			Cta_Contable,
			Id_Centro_Costo,
			Centro_Costo,
			Anterior,
			Debe,
			Haber,
			Diferencia,
			Deudor,
			Acreedor,
			Columna_Bal,
			Alias_Cta_Padre)
			VALUES
			(@Nro_Cta_Contable,
			@Alias,
			@Cta_Contable,
			@Id_Centro_Costo,
			@Centro_Costo,
			@Anterior,
			@Debe,
			@Haber,
			@Diferencia,
			@Deudor,
			@Acreedor,
			@Columna_Bal,
			@Alias_Cta_Padre)
		END
		ELSE
		BEGIN
			SELECT
			@Debe		= ISNULL(Debe, 0),
			@Haber		= ISNULL(Haber, 0),
			@Diferencia = ISNULL(Diferencia, 0)
			FROM #Rpt_Balance_Sumas_Saldos
			WHERE
			Nro_Cta_Contable = @Nro_Cta_Contable

			PRINT 'Acumulados de @Nro_Cta_Contable: ' + @Nro_Cta_Contable + '. @Debe: ' + CONVERT(VARCHAR(10), @Debe) + '. @Haber: ' + CONVERT(VARCHAR(10), @Haber) + '. @Diferencia: ' + CONVERT(VARCHAR(10), @Diferencia)
			
			SET @Debe	= @Debe + @Debe_Suma
			SET @Haber	= @Haber + @Haber_Suma

			SET @Diferencia	= @Debe - @Haber

			IF(@Diferencia < 0)
			BEGIN
				SET @Acreedor	= @Diferencia * (-1)
			END
			ELSE
			BEGIN
				SET @Deudor		= @Diferencia
			END

			UPDATE #Rpt_Balance_Sumas_Saldos
			SET
			Debe = @Debe,
			Haber = @Haber,
			Diferencia = @Diferencia,
			Deudor = @Deudor,
			Acreedor = @Acreedor
			WHERE
			Nro_Cta_Contable = @Nro_Cta_Contable
		END

		FETCH NEXT FROM curBalance_Sumas_Saldos_Cur INTO @Id_Cta_Contable, @Debe_Suma, @Haber_Suma
	END
	CLOSE curBalance_Sumas_Saldos_Cur
	DEALLOCATE curBalance_Sumas_Saldos_Cur

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'SALDO ANTERIOR'
	END

	CREATE TABLE #SaldoAnterior_Sumas_Saldos
	(
	Id_Cta_Contable					INT
	)

	/*=============================================================================================================================*/

	SET @SqlStr = 'INSERT INTO #SaldoAnterior_Sumas_Saldos (Id_Cta_Contable) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable '													+ CHAR(13) + 
					'FROM Pla_Ctas_Cuentas_Contables '									+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'Imputable = 1 '													+ CHAR(13) + 
					'AND Id_Plan_Cta = ' + CONVERT(VARCHAR(10), @pId_Plan_Cta)

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND Alias = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr
	
	/*=============================================================================================================================*/

	DECLARE curBalance_Sumas_Saldos_Cur CURSOR FOR
	SELECT 
	Id_Cta_Contable
	FROM #SaldoAnterior_Sumas_Saldos

	OPEN curBalance_Sumas_Saldos_Cur
	FETCH NEXT FROM curBalance_Sumas_Saldos_Cur INTO @Id_Cta_Contable
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @Nro_Cta_Contable	= ''
		SET @Alias				= 0
		SET @Cta_Contable		= ''
		SET @Id_Centro_Costo	= ''
		SET @Centro_Costo		= ''
		SET @Anterior			= 0
		SET @Debe				= 0
		SET @Haber				= 0
		SET @Diferencia			= 0
		SET @Deudor				= 0
		SET @Acreedor			= 0
		SET @Columna_Bal		= 0
		SET @Alias_Cta_Padre	= 0
		SET @Anterior			= 0

		SELECT
		@Nro_Cta_Contable	= ISNULL(Nro_Cta_Contable, ''),
		@Alias				= ISNULL(Alias, 0),
		@Cta_Contable		= ISNULL(Descripcion, ''),
		@Columna_Bal		= ISNULL(Columna, 0),
		@Alias_Cta_Padre	= ISNULL(Id_Cuenta_Padre, 0)
		FROM Pla_Ctas_Cuentas_Contables
		WHERE
		Id_Cta_Contable = @Id_Cta_Contable

		SET @Debe		= 0
		SET @Haber		= 0
		SET @Diferencia	= 0

		SET @pFlag_Desglozar_CC = 0 /*Hablado con Gabriel, quede fijo en 0 porque sino depende del parametro Tipo_Asto_Cierre*/
		
		SET @Anterior = dbo.CF_Cta_Cont_Saldo (	@pFecha_Desde, 
												@pFecha_Desde, --@pFecha_Hasta
												@Alias, 
												@pId_Plan_Cta, 
												1 /*@Flag_Inc_SA*/, 
												@pFlag_Desglozar_CC,	
												@Id_Centro_Costo,
												0 /*@Flag_CentroCosto_Recur*/,
												0 /*@Flag_Unid_Neg*/,
												@pId_Unid_Negocio,
												0 /*@Flag_SoloAsientos*/)

		SET @Id_Centro_Costo	= 0
		SET @Centro_Costo		= ''

		SET @Flag_Existe_Registro_En_Cola = ISNULL((SELECT MAX(1) 
													FROM #Rpt_Balance_Sumas_Saldos 
													WHERE 
													Nro_Cta_Contable = @Nro_Cta_Contable)
													, 0)
		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Flag_Existe_Registro_En_Cola: ' + CONVERT(VARCHAR(10), @Flag_Existe_Registro_En_Cola)
		END

		IF(@Flag_Existe_Registro_En_Cola = 0)
		BEGIN
			IF(@Anterior < 0)
			BEGIN
				SET @Acreedor	= @Anterior * (-1)
			END
			ELSE
			BEGIN
				SET @Deudor		= @Anterior
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Anterior: ' + CONVERT(VARCHAR(20), @Anterior) + '. @Acreedor: ' + CONVERT(VARCHAR(20), @Acreedor) + '. @Deudor: ' + CONVERT(VARCHAR(20), @Deudor)
			END

			INSERT INTO #Rpt_Balance_Sumas_Saldos
			(Nro_Cta_Contable,
			Alias,
			Cta_Contable,
			Id_Centro_Costo,
			Centro_Costo,
			Anterior,
			Debe,
			Haber,
			Diferencia,
			Deudor,
			Acreedor,
			Columna_Bal,
			Alias_Cta_Padre)
			VALUES
			(@Nro_Cta_Contable,
			@Alias,
			@Cta_Contable,
			@Id_Centro_Costo,
			@Centro_Costo,
			@Anterior,
			@Debe,
			@Haber,
			@Diferencia,
			@Deudor,
			@Acreedor,
			@Columna_Bal,
			@Alias_Cta_Padre)
		END
		ELSE
		BEGIN
			SELECT
			@Debe		= ISNULL(Debe, 0),
			@Haber		= ISNULL(Haber, 0),
			@Diferencia = ISNULL(Diferencia, 0)
			FROM #Rpt_Balance_Sumas_Saldos
			WHERE
			Nro_Cta_Contable = @Nro_Cta_Contable

			PRINT 'Acumulados de @Nro_Cta_Contable: ' + @Nro_Cta_Contable + '. @Debe: ' + CONVERT(VARCHAR(20), @Debe) + '. @Haber: ' + CONVERT(VARCHAR(20), @Haber) + '. @Diferencia: ' + CONVERT(VARCHAR(20), @Diferencia)

			IF((@Diferencia + @Anterior) < 0)
			BEGIN
				SET @Acreedor = (@Diferencia + @Anterior) * (-1)
			END
			ELSE
			BEGIN
				SET @Deudor = (@Diferencia + @Anterior)
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Diferencia: ' + CONVERT(VARCHAR(20), @Diferencia) + '. @Anterior: ' + CONVERT(VARCHAR(20), @Anterior) + '. @Acreedor: ' + CONVERT(VARCHAR(20), @Acreedor) + '. @Deudor: ' + CONVERT(VARCHAR(20), @Deudor)
				--@Diferencia: 0.00. @Anterior: -720927.00. @Acreedor: 720927.00. @Deudor: 0.00
			END

			UPDATE #Rpt_Balance_Sumas_Saldos
			SET
			Anterior = @Anterior,
			Acreedor = @Acreedor,
			Deudor = @Deudor
			WHERE
			Nro_Cta_Contable = @Nro_Cta_Contable			

		END

		FETCH NEXT FROM curBalance_Sumas_Saldos_Cur INTO @Id_Cta_Contable
	END
	CLOSE curBalance_Sumas_Saldos_Cur
	DEALLOCATE curBalance_Sumas_Saldos_Cur

	/*=============================================================================================================================*/	

	UPDATE #Rpt_Balance_Sumas_Saldos
	SET
	Anterior	= ISNULL(Anterior, 0),
	Debe		= ISNULL(Debe, 0),
	Haber		= ISNULL(Haber, 0),
	Diferencia	= ISNULL(Diferencia, 0),
	Deudor		= ISNULL(Deudor, 0),
	Acreedor	= ISNULL(Acreedor, 0)
	
	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	SELECT * FROM #Rpt_Balance_Sumas_Saldos	
	WHERE
	(ISNULL(Debe, 0) <> 0 AND ISNULL(Haber, 0) <> 0)
	OR ISNULL(Anterior, 0) <> 0
	ORDER BY Nro_Cta_Contable
	
	/*=============================================================================================================================*/
	/*=============================================================================================================================*/
	
	DROP TABLE #Asientos_Sumas_Saldos
	DROP TABLE #Cbtes_Sumas_Saldos
	DROP TABLE #SaldoAnterior_Sumas_Saldos
	DROP TABLE #Rpt_Balance_Sumas_Saldos
	
	/*=============================================================================================================================*/
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Balance_Sumas_Saldos_Rpt'
	END
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	RETURN 9999
END CATCH

RETURN 0

/*
EXEC dbo.CPJ_Balance_Sumas_Saldos_Rpt '{
										"ModoDebug":"1",
										"Id_Usuario":"-1",
										"Fecha_Desde":"20210501",
										"Fecha_Hasta":"20210531",
										"Flag_incluirSoloAsientos":"0",
										"Flag_FiltrarId_CC":"0",
										"Id_Centro_Costo":"0",
										"Id_Plan_Cta":"3",
										"Id_Unid_Negocio":"",
										"Flag_Desglozar_CC":"0",
										"Flag_Excluir_Asientos_Cierre":"0"
										}'

EXEC dbo.CPJ_Balance_Sumas_Saldos_Rpt '{
										"ModoDebug":"1",
										"Id_Usuario":"-1",
										"Fecha_Desde":"20210501",
										"Fecha_Hasta":"20210531",
										"Flag_incluirSoloAsientos":"0",
										"Flag_FiltrarId_CC":"0",
										"Id_Centro_Costo":"0",
										"Id_Plan_Cta":"3",
										"Id_Unid_Negocio":"",
										"Flag_Desglozar_CC":"0",
										"Flag_Excluir_Asientos_Cierre":"0",
										"Id_Alias_Cta_Contable":"6"
										}'
*/
